﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class SchoolYear : PI.FM.N000.Base.BL.DBD.BaseTable<BO.SchoolYear>
    {
        #region Static factory
        private static SchoolYear _factory = null;

        public static SchoolYear DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new SchoolYear();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_SchoolYear";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Weight", "Weight"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsActive", "IsActive"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsClosed", "IsClosed"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Flags", "Flags"));
        }
        #endregion

    #region Commands definition
    public enum Commands
    {
        RestoreBySearch = 10,
        CountBySearch = 11
    }
    #endregion

    #region Get Commands
    protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
    {
      switch (CommandID)
      {
          case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
          case (int)Commands.CountBySearch  : return new Command_CountBySearch();
      }
      
      return base.DoGetCommand(CommandID);
    }
    #endregion

    #region Additional Commands Classes
    class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.SchoolYear>
    {
        public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.SchoolYear.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

      protected override void InitializeParametrs()
      {
          Add(new Gemini.Core.BL.DBD.Param("IsActive", Gemini.Core.BL.DAL.SqlTypes.Bit));
          Add(new Gemini.Core.BL.DBD.Param("IsClosed", Gemini.Core.BL.DAL.SqlTypes.Bit));
      }

      protected override void InitializeCommandText()
      {
          _commandText = "PIZB1200_SchoolYear_RestoreBySearch";
      }
    }

    class Command_CountBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.SchoolYear>
    {
        public Command_CountBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.SchoolYear.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

        protected override void InitializeParametrs()
        {
            Add(new Gemini.Core.BL.DBD.Param("IsActive", Gemini.Core.BL.DAL.SqlTypes.Bit));
            Add(new Gemini.Core.BL.DBD.Param("IsClosed", Gemini.Core.BL.DAL.SqlTypes.Bit));
        }

        protected override void InitializeCommandText()
        {
            _commandText = "PIZB1200_SchoolYear_CountBySearch";
        }
    }
    #endregion
    }
}
